//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "MMSystem.h"
#include "windowsx.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "MMACMDlg"
#pragma link "MMDSPObj"
#pragma link "MMObj"
#pragma link "MMWave"
#pragma link "MMPCMSup"
#pragma link "MMRegs"
#pragma resource "*.dfm"
TForm1 *Form1;

PACMConvert FPACMConvert;
char* FDstBuffer;
char* FSrcBuffer;

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner): TForm(Owner)
{
}

//---------------------------------------------------------------------------
void __fastcall TForm1::btnStartClick(TObject *Sender)
{

   mmregs:TWaveFormatEx wfx;
   char* p;

   if (MMACM1->ChooseFormat(NULL,"Select Format"))
   {
      // setup a source PCM format
      pcmBuildWaveHeader(&wfx,16,1,22050);

      // alloc a buffer for conversion
      FSrcBuffer = (char*)GlobalAllocPtr(GPTR, 4096);

      // setup our conversion instance
      FPACMConvert = acmBeginConvert(&wfx,MMACM1->PWaveFormat,FSrcBuffer,4096,True);
      if (FPACMConvert == NULL)
          throw Exception("Unable to convert to destination format");

      // The destination buffer is allocated from acmBeginConvert
      FDstBuffer = FPACMConvert->lpDstBuffer;

      // create a destination file
      MMWaveFile1->Wave->CreateFileC("C:\TEST.WAV",MMACM1->PWaveFormat);

      btnStart->Enabled   = False;
      btnStop->Enabled    = True;
      btnConvert->Enabled = True;
   }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::btnStopClick(TObject *Sender)
{
   // playing has stopped, free all
   MMWaveFile1->Wave->CloseFile();
   acmDoneConvert(FPACMConvert);
   GlobalFreePtr(FSrcBuffer);

   btnStart->Enabled   = True;
   btnStop->Enabled    = False;
   btnConvert->Enabled = False;

}
//---------------------------------------------------------------------------
void __fastcall TForm1::btnConvertClick(TObject *Sender)
{

   long nConvert;

   // we fill our source buffer here, you must your data in the buffer
   ZeroMemory(FSrcBuffer,4096);

   // do the conversion
   nConvert = acmDoConvert(FPACMConvert, 4096);

   if (nConvert > 0)
   {
      // write the data out
      MMWaveFile1->Wave->WriteDataBytes(FDstBuffer, nConvert);

      // update the bytes you have read
      FPACMConvert->dwBytesRead -= nConvert;
   }
}
//---------------------------------------------------------------------------
